#Chapter 10 Logit

gssD=svydesign(id=~1,data=gss,weights=~wtss)
#Model one IV with svyglm
modelA= svyglm(voted04~educ.n,design=gssD,na.action=na.omit,
        family=quasibinomial)
modelA
summary (modelA)
orci    (modelA)
logregR2(modelA)

#More than one IV
modelB= svyglm(voted04~educ.n+age,design=gssD,na.action=na.omit,family=quasibinomial)
modelB
summary (modelB)
orci    (modelB)
logregR2(modelB)
wtd.cor(gss$educ.n,gss$age,weight=gss$wtss)
#Box 10-1
pchisqC(modelA$dev,modelB$dev,1)

#Predicted probabilities, one predictor
data1=data.frame(educ.n=(0:20))
data1
modelA
data1$pred=exp(-2.4336+data1$educ.n*.2456)/(1+exp(-2.4336+data1$educ.n*.2456))
data1
plot(data1$educ.n,data1$pred)

plot(data1$educ.n,data1$pred,type="b",xlab="Years of education",
     ylab="Predicted probability", 
     main="Predicted probability of Voting, by Education",
     font.main=1,lwd=2)
abline(h=.5,lty=3,lwd=.5) #adds reference line at .5
#dev.off()

#Predicted probabilities, more than one predictor
wtd.mean(gss$age, weights=gss$wtss)
modelB=svyglm(voted04~educ.n+age,design=gssD,na.action=na.omit,family=quasibinomial)
modelB
data1$predmean=exp(-5.73777+.31090*data1$educ.n+.05307*46.21656)/
            (1+exp(-5.73777+.31090*data1$educ.n+.05307*46.21656))
data1
data1$pred26=exp(-5.73777+.31090*data1$educ.n+.05307*26)/
          (1+exp(-5.73777+.31090*data1$educ.n+.05307*26))

data1$pred65=exp(-5.73777+.31090*data1$educ.n+.05307*65)/
          (1+exp(-5.73777+.31090*data1$educ.n+.05307*65))
data1[, c("educ.n","pred26","pred65")]

matplot(data1$educ.n, data1[, c("pred26","pred65")], type="l", lty=c(5,1), 
  ylab="Predicted probability", 
  main=list("Predicted Probability of Voting, by Education (Selected Ages)",cex=1),
  xlab="Education (years)", lwd=2, col="black")  
abline(h=.5,lty=3,lwd=.5)
legend("topleft",
  legend=c("Age 26","Age 65"),
  lty=c(5,1),
  lwd=2, 
  title="",#Title is unnecessary
  inset=0.1,
  bty="n")

#For unweighted data: glm

sortC(states,c("gunlaw.rank", "state"), gunlaw.rank)
#California is ranked #1; Oklahoma is ranked 48
wtd.cor(states$gunlaw.rank, states$secularism)
modelC=glm(obama.win08~gunlaw.rank+secularism,data=states,family=binomial)
modelC
summary (modelC)
orci    (modelC)
logregR2(modelC)

summary(cbind(states$gunlaw.rank, states$secularism))
describe(states$gunlaw.rank)
describe(states$secularism)

#Obtain predicted probabilities for secularism=53.5, 100.5, 139.8
data2=data.frame(gunlaw.rank=(1:48))
data2
modelC #To recall coefficients

data2$secLow=exp(3.4393 -0.2200*data2$gunlaw.rank + 0.0279*53.5)/
         (1 +exp(3.4393 -0.2200*data2$gunlaw.rank + 0.0279*53.5))

data2$secMed=exp(3.4393 -0.2200*data2$gunlaw.rank + 0.0279*100.5)/
          (1 +exp(3.4393 -0.2200*data2$gunlaw.rank + 0.0279*100.5))

data2$secHigh=exp(3.4393 -0.2200*data2$gunlaw.rank + 0.0279*139.8)/
          (1 +exp(3.4393 -0.2200*data2$gunlaw.rank + 0.0279*139.8))
data2

matplot(data2$gunlaw.rank, data2[, c("secLow","secMed","secHigh")], type="l", lty=c(3,2,1), 
   ylab="Predicted probability", 
   main=list("Predicted Probability of Obama Vote, by Brady Gun Rank and Secularism",cex=1),
   xlab="Gun Rank (higher scores=fewer restrictions)", lwd=2, col="black" ,
   xlim=c(0,50)) 
 
 abline(h=.5,lty=3,lwd=.5)

 legend("topright",
   legend=c("Low","Medium","High"),
   lty=c(3,2,1), col="black",
   lwd=2, 
   title="Secularism",
   inset=0.1,
   bty="n")

#Ex1. world: democ.regime, frac.eth, gdp.10.thou
modelD=glm(democ.regime~frac.eth+gdp.10.thou, data=world,family=binomial)
summary (modelD)
orci    (modelD)
logregR2(modelD)
modelD
summary(cbind(world$frac.eth,world$gdp.10.thou))
describe(world$frac.eth)
summary(world$frac.eth)
data3=data.frame(frac.eth=seq(0,.93,.01))
data3
#use the poorest lowest quartile, the median, and the highest quartile
data3$LowGDP=exp(0.8418-1.5919*data3$frac.eth+0.7125*.0503)/
          (1+exp(0.8418-1.5919*data3$frac.eth+0.7125*.0503))

data3$MidGDP=exp(0.8418-1.5919*data3$frac.eth+0.7125*.1897)/
         (1+exp(0.8418-1.5919*data3$frac.eth+0.7125*.1897))
 
data3$HighGDP=exp(0.8418-1.5919*data3$frac.eth+0.7125*.6320)/
           (1+exp(0.8418-1.5919*data3$frac.eth+0.7125*.6320))
data3
#Ex2. nesD: voted, educ.r, age
modelE= svyglm(voted~educ.r+age,design=nesD,na.action=na.omit,
        family=quasibinomial)
modelE
summary (modelE)
orci    (modelE)
logregR2(modelE)
describe(nes$educ.r,weigts=nes$wt)
data4=data.frame(educ.r=(0:17))
data4

data4$pred26=exp( -4.83001+.35786*data4$educ.r+.03139*26)/
          (1+exp( -4.83001+.35786*data4$educ.r+.03139*26))

data4$pred65=exp( -4.83001+.35786*data4$educ.r+.03139*65)/
          (1+exp( -4.83001+.35786*data4$educ.r+.03139*65))
data4

matplot(data4$educ.r, data4[, c("pred26","pred65")], type="l", lty=c(5,1), 
  ylab="Predicted probability", 
  main=list("Predicted Probability of Voting, by Education (Selected Ages)",cex=1),
  xlab="Education (years)", lwd=2, col="black")  
abline(h=.5,lty=3,lwd=.5)
legend("topleft",
  legend=c("Age 26","Age 65"),
  lty=c(5,1),
  lwd=2, 
  title="",
  inset=0.1,
  bty="n")
